/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.entity;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lotr.client.LOTRAttackTiming;
import lotr.common.item.LOTRWeaponStats;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;

public class LOTRSwingHandler {
    private static Map<EntityLivingBase, SwingTime> entitySwings = new HashMap<EntityLivingBase, SwingTime>();
    private static float swingFactor = 0.8f;

    public LOTRSwingHandler() {
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        ItemStack item;
        SwingTime swt;
        EntityLivingBase entity = event.entityLiving;
        World world = entity.field_70170_p;
        if (world.field_72995_K && (swt = entitySwings.get(entity)) == null && entity.field_82175_bq && entity.field_110158_av == 0 && LOTRWeaponStats.isMeleeWeapon(item = entity.func_70694_bm())) {
            int time = 0;
            time = entity instanceof EntityPlayer ? LOTRWeaponStats.getAttackTimePlayer(item) : LOTRWeaponStats.getAttackTimePlayer(item);
            time = Math.round((float)time * swingFactor);
            swt = new SwingTime();
            swt.swing = 1;
            swt.swingPrev = 0;
            swt.swingMax = time;
            entitySwings.put(entity, swt);
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71441_e == null) {
                entitySwings.clear();
            } else if (!mc.func_147113_T()) {
                ArrayList<EntityLivingBase> removes = new ArrayList<EntityLivingBase>();
                for (Map.Entry<EntityLivingBase, SwingTime> e : entitySwings.entrySet()) {
                    EntityLivingBase entity = e.getKey();
                    SwingTime swt = e.getValue();
                    ++swt.swing;
                    swt.swingPrev = swt.swingPrev;
                    if (swt.swing <= swt.swingMax) continue;
                    removes.add(entity);
                }
                for (EntityLivingBase entity : removes) {
                    entitySwings.remove(entity);
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        EntityClientPlayerMP entityplayer;
        if (event.phase == TickEvent.Phase.START && (entityplayer = Minecraft.func_71410_x().field_71439_g) != null) {
            this.tryUpdateSwing((EntityLivingBase)entityplayer);
        }
    }

    @SubscribeEvent
    public void preRenderPlayer(RenderPlayerEvent.Pre event) {
        this.tryUpdateSwing((EntityLivingBase)event.entityPlayer);
    }

    @SubscribeEvent
    public void preRenderLiving(RenderLivingEvent.Pre event) {
        this.tryUpdateSwing(event.entity);
    }

    private void tryUpdateSwing(EntityLivingBase entity) {
        if (entity == Minecraft.func_71410_x().field_71439_g) {
            if (LOTRAttackTiming.fullAttackTime > 0) {
                float max = LOTRAttackTiming.fullAttackTime;
                float swing = (max - (float)LOTRAttackTiming.attackTime) / max;
                float pre = (max - (float)LOTRAttackTiming.prevAttackTime) / max;
                swing /= swingFactor;
                pre /= swingFactor;
                if (swing <= 1.0f) {
                    entity.field_70733_aJ = swing;
                    entity.field_70732_aI = pre;
                }
            }
        } else {
            SwingTime swt = entitySwings.get(entity);
            if (swt != null) {
                entity.field_70733_aJ = (float)swt.swing / (float)swt.swingMax;
                entity.field_70732_aI = (float)swt.swingPrev / (float)swt.swingMax;
            }
        }
    }

    private static class SwingTime {
        public int swingPrev;
        public int swing;
        public int swingMax;

        private SwingTime() {
        }
    }
}

